<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Custom FAQ Accordion</title>
  <style>
    .faq-container-unique {
      font-family: Arial, sans-serif;
      max-width: 800px;
      margin: 0 auto;
    }

    .faq-title-unique {
      text-align: center;
      font-size: 2rem;
      font-weight: bold;
      margin-bottom: 20px;
    }

    .faq-item-unique {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 4px;
      overflow: hidden;
    }

    .faq-question-unique {
      background-color: #00b4c5;
      color: white;
      padding: 15px 20px;
      cursor: pointer;
      position: relative;
      font-weight: bold;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    .faq-question-unique::before {
      content: '+';
      font-size: 1.2rem;
      margin-right: 10px;
    }

    .faq-item-unique.open .faq-question-unique::before {
      content: '−';
    }

    .faq-answer-unique {
      background-color: #fff;
      color: #333;
      padding: 20px;
      display: none;
    }

    .faq-item-unique.open .faq-answer-unique {
      display: block;
    }
  </style>
</head>
<body>
  <div class="faq-container-unique">
    <div class="faq-title-unique">FAQ</div>

    <div class="faq-item-unique">
      <div class="faq-question-unique">Is the AC not turning on?</div>
      <div class="faq-answer-unique">
        Solution: If your AC is not turning on, start by checking your thermostat settings to ensure it is set to ‘cool.’ Additionally, make sure that the circuit breaker has not tripped. If neither of these issues is the problem, it may be a more serious issue with the compressor or another component, which will require the assistance of a professional for repair.
      </div>
    </div>

    <div class="faq-item-unique">
      <div class="faq-question-unique">Weak airflow from ACs?</div>
      <div class="faq-answer-unique">
        Solution: Check the air filter and vents for blockages. Dirty filters or closed vents can restrict airflow. If the issue persists, the blower motor or ductwork may need inspection by a technician.
      </div>
    </div>
  </div>

  <script>
    const faqItems = document.querySelectorAll('.faq-item-unique');

    faqItems.forEach(item => {
      const question = item.querySelector('.faq-question-unique');
      question.addEventListener('click', () => {
        item.classList.toggle('open');
      });
    });
  </script>
</body>
</html>
