<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Custom FAQ Accordion</title>
  <style>
    .faq-container-unique {
      font-family: Arial, sans-serif;
      max-width: 800px;
      margin: 0 auto;
    }

    .faq-title-unique {
      text-align: center;
      font-size: 2rem;
      font-weight: bold;
      margin-bottom: 20px;
    }

    .faq-item-unique {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 4px;
      overflow: hidden;
    }

    .faq-question-unique {
      background-color: #00b4c5;
      color: white;
      padding: 15px 20px;
      cursor: pointer;
      position: relative;
      font-weight: bold;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    .faq-question-unique::before {
      content: '+';
      font-size: 1.2rem;
      margin-right: 10px;
    }

    .faq-item-unique.open .faq-question-unique::before {
      content: '−';
    }

    .faq-answer-unique {
      background-color: #fff;
      color: #333;
      padding: 20px;
      display: none;
    }

    .faq-item-unique.open .faq-answer-unique {
      display: block;
    }
  </style>
</head>
<body>
  <div class="faq-container-unique">
    <div class="faq-title-unique">FAQ</div>

    <div class="faq-item-unique open">
      <div class="faq-question-unique">Is the Washing machine not draining?</div>
      <div class="faq-answer-unique">
      Solution: Check if there are any clogs or blockages in the drain hose. In case the hose is free from any obstructions, it may indicate a malfunction with the pump or another part of the system, and you will need the assistance of a professional to get it fixed.
      </div>
    </div>

    <div class="faq-item-unique">
      <div class="faq-question-unique">Is the Washing machine making strange noises?</div>
      <div class="faq-answer-unique">
      Solution: Loud sounds from the motor or drum may suggest a malfunction. Seek prompt assistance from a qualified technician to avoid exacerbating the problem.
      </div>
    </div>
  </div>

  <script>
    document.querySelectorAll('.faq-question-unique').forEach(button => {
      button.addEventListener('click', () => {
        const faqItem = button.parentElement;
        faqItem.classList.toggle('open');
      });
    });
  </script>
</body>
</html>
