<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>ACE Navbar</title>

  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />

  <!-- Font Awesome for Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />

  <style>
    .navbar {
      padding-top: 6px;
      padding-bottom: 6px;
    }
    .navbar-brand img {
      height: 100px;
      transition: height 0.3s ease;
    }
    .navbar-brand {
      white-space: nowrap;
    }
    .navbar-brand div {
      line-height: 1.1;
    }
    .nav-link {
      color: #212529 !important;
      font-weight: 500;
      margin: 0 10px;
      font-size: 15px;
      text-transform: uppercase;
    }
    .nav-link.active {
      color: #00bcd4 !important;
    }
    .contact-btn {
      background-color: #00bcd4;
      color: white;
      padding: 8px 16px;
      border-radius: 5px;
      font-weight: 500;
      font-size: 14px;
      text-decoration: none;
      display: flex;
      align-items: center;
      gap: 8px;
      white-space: nowrap;
    }
    .whatsapp-btn {
      background-color: #25D366;
      color: white;
      padding: 8px 12px;
      border-radius: 5px;
      font-size: 18px;
      text-decoration: none;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      margin-left: 10px;
      white-space: nowrap;
    }

    /* Responsive adjustments */
    @media (max-width: 992px) {
      .navbar-brand img {
        height: 80px;
      }
      .nav-link {
        margin: 0 6px;
        font-size: 14px;
      }
      .contact-btn {
        padding: 6px 12px;
        font-size: 13px;
      }
      .whatsapp-btn {
        font-size: 16px;
        padding: 6px 10px;
      }
    }

    @media (max-width: 576px) {
      .navbar-brand {
        flex-direction: column;
        align-items: flex-start;
      }
      .navbar-brand img {
        height: 60px;
        margin-bottom: 0.25rem;
      }
      .navbar-brand div {
        font-size: 14px;
        font-weight: 600;
      }
      .nav-link {
        font-size: 13px;
        margin: 0 4px;
      }
      .contact-btn {
        font-size: 12px;
        padding: 5px 10px;
      }
      .whatsapp-btn {
        font-size: 14px;
        padding: 5px 8px;
      }
      .d-lg-flex {
        display: none !important;
      }
    }
  </style>
</head>
<body>
  <nav class="navbar navbar-expand-lg bg-white border-bottom">
    <div class="container-fluid px-4 d-flex align-items-center justify-content-between">
      <!-- Logo and company info -->
      <a class="navbar-brand d-flex align-items-center" href="index">
        <img src="images/logo.png" alt="ACE Logo" class="me-2" />
        <div>
          <div class="fw-bold">KRISH HOME APPLIANCES</div>
        </div>
      </a>

      <!-- Mobile toggle -->
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
        aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>

      <!-- Navigation links -->
      <div class="collapse navbar-collapse" id="navbarNav">
        <ul class="navbar-nav ms-auto mb-2 mb-lg-0 align-items-center">
          <li class="nav-item"><a class="nav-link" href="index">HOME</a></li>
          <li class="nav-item"><a class="nav-link" href="about">ABOUT</a></li>
          <li class="nav-item"><a class="nav-link" href="services">SERVICES</a></li>
         
          <li class="nav-item"><a class="nav-link" href="contact">CONTACT</a></li>

          <!-- WhatsApp for mobile -->
          <li class="nav-item d-lg-none mt-2">
            <a class="nav-link text-success" href="https://wa.me/+919566871551" target="_blank">
              <i class="fab fa-whatsapp"></i> Chat on WhatsApp
            </a>
          </li>
        </ul>
      </div>

      <!-- Phone & WhatsApp icons for desktop -->
      <div class="d-none d-lg-flex align-items-center">
        <a href="tel:+919566871551" class="contact-btn">
          <i>📞</i> +9195668 71551
        </a>
        <a href="https://wa.me/+919566871551" target="_blank" class="whatsapp-btn">
          <i class="fab fa-whatsapp"></i>
        </a>
      </div>
    </div>
  </nav>

  <!-- Bootstrap Bundle JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Active Link Script -->
  <script>
    const currentPath = window.location.pathname.toLowerCase();
    const navLinks = document.querySelectorAll('.nav-link');

    navLinks.forEach(link => {
      const href = link.getAttribute('href').toLowerCase();

      // Match exact file or folder or root
      if (
        (currentPath === '/' && href === 'home') ||
        currentPath.includes(href)
      ) {
        link.classList.add('active');
      }
    });
  </script>
</body>
</html>
