<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>AC Units Display</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f7f9fc;
      margin: 0;
      padding: 0;
    }

    .ac-container-grid {
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      grid-template-rows: repeat(2, 1fr);
      gap: 20px;
      max-width: 1200px;
      margin: 50px auto;
      padding: 20px;
    }

    .ac-item {
      position: relative;
      border: 2px solid #e0e0e0;
      border-radius: 12px;
      overflow: hidden;
      box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
      cursor: pointer;
    }

    .ac-item:hover {
      transform: translateY(-10px);
      box-shadow: 0 12px 24px rgba(0, 0, 0, 0.15);
    }

    .ac-item img {
      width: 100%;
      height: 250px; /* Fixed height for uniform display */
      object-fit: cover; /* Ensures images fill area without distortion */
      display: block;
      transition: transform 0.4s ease;
    }

    .ac-item:hover img {
      transform: scale(1.05);
    }

    .ac-item::after {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      height: 100%;
      width: 100%;
      background: rgba(0, 0, 0, 0);
      transition: background 0.3s ease;
    }

    .ac-item:hover::after {
      background: rgba(0, 0, 0, 0.1);
    }

    .ac-label {
      position: absolute;
      bottom: 10px;
      left: 10px;
      background: rgba(0, 0, 0, 0.6);
      color: white;
      padding: 5px 10px;
      border-radius: 5px;
      font-size: 0.9rem;
      display: none;
    }

    .ac-item:hover .ac-label {
      display: block;
    }
  </style>
</head>
<body>

  <div class="ac-container-grid">
    <div class="ac-item ac-unit-commercial-large">
      <img src="https://customerservicecenterindia.com/images/2.jpg" alt="Large commercial AC unit">
    </div>
    <div class="ac-item ac-unit-window-mounted">
      <img src="https://www.rightcliq.in/blogs/images/blogs/proper-care-of-refrigerator.jpg" alt="Window mounted AC unit">
    </div>
    <div class="ac-item ac-unit-bedroom-indoor">
      <img src="https://www.jiomart.com/images/product/original/491604488/ifb-25-litres-convection-microwave-oven-25bc3-digital-o491604488-p590442567-2-202108130151.jpeg?im=Resize=(420,420)" alt="Indoor AC in bedroom">
    </div>
    <div class="ac-item ac-unit-livingroom-indoor">
      <img src="https://subzerovikingrepair.com/wp-content/uploads/2018/05/condenser-coils-maintenance.jpg" alt="Indoor AC in living room">
    </div>
    <div class="ac-item ac-unit-exterior-green-wall">
      <img src="https://5.imimg.com/data5/XX/EE/GLADMIN-63685627/microwave-oven-repairing-service-500x500.jpg" alt="AC on green exterior wall">
    </div>
    <div class="ac-item ac-unit-urban-wall">
      <img src="https://www.ifbcustomercare.in/images/contact-image.jpg" alt="AC on urban wall">
    </div>
  </div>

</body>
</html>
